--   W O R K L O A D   C O D E


-- Coming at it from the National VA Lab Codes angle (could have gaps)
Drop table #Labs0
SELECT NationalVALabCodeSID, LabProcedure, WorkloadCode, DefaultLOINCSid
INTO #Labs0
FROM CDWWork.DIM.NationalVALabCode
WHERE
  (upper(LabProcedure) like 'ANA-%' or 
   upper(LabProcedure) like 'ANA %' or 
   upper(LabProcedure) like 'ANA~%' or 
   LabProcedure like '%antinuc%')
  and LabProcedure not like '%analysis%'
  and LabProcedure not like '%mycin%'
  --and LabProcedure not like '%Methylene%'
  --and LabProcedure not like '%Tetra%'
  --and LabProcedure not like '%Vinyl%'
  --and LabProcedure not like '%Sodium%'
  --and LabProcedure not like '%Melanin%'



select LabProcedure, WorkloadCode, count(*) AS [Count]
FROM #Labs0
Group by LabProcedure, WorkloadCode
ORDER BY count(*) DESC, WorkloadCode, LabProcedure


SELECT
  LabProcedure = CASE
    When CHARINDEX('~', LabProcedure) = 0 Then LabProcedure
    Else SUBSTRING(LabProcedure, 1, CHARINDEX('~', LabProcedure) - 1)
  End,
  SUBSTRING(WorkloadCode, 1, 5) AS WorkloadCode,
  count(*) AS [Count]
FROM #Labs0
group by CASE
    When CHARINDEX('~', LabProcedure) = 0 Then LabProcedure
    Else SUBSTRING(LabProcedure, 1, CHARINDEX('~', LabProcedure) - 1)
    End, SUBSTRING(WorkloadCode, 1, 5)
ORDER BY 3 desc


-- Coming at it from the Lab Chem Test angle (recommended)

drop table #labs
select distinct p.sta3n
              ,lo.[LOINCSID]
              ,lo.LOINC
              ,lo.[Component]
              ,nl.[LabProcedure]
              ,nl.WorkloadCode
              ,left(nl.WorkLoadCode, 5) AS WorkloadCode5
              ,p.LabChemTestSID
              ,p.LabChemTestName
              ,p.LabChemPrintTestName
Into #Labs
from [CDWWork].[dim].[LabChemTest] p
left outer join [CDWWork].[dim].[NationalVALabCode] nl on nl.[NationalVALabCodeSID] = p.[NationalVALabCodeSID]
left outer join [CDWWork].[dim].[LOINC] lo on lo.[LOINCSID] = nl.[DefaultLOINCSID]
where (upper(LabProcedure) like 'ANA-%' or 
       upper(LabProcedure) like 'ANA %' or 
       upper(LabProcedure) like 'ANA~%' or 
       LabProcedure like '%antinuc%')
  and LabProcedure not like '%analysis%'
  and LabProcedure not like '%mycin%'
  --AND p.LabChemTestName not like 'ELECTROLYTE%'
  --AND p.LabChemTestName not like '%Tetra%'
  --AND p.LabChemTestName not like '%Vinyl%'
  --AND p.LabChemTestName not like '%Sodium%'
  --AND p.LabChemTestName not like '%Melanin%'
  --AND p.LabChemTestName NOT LIKE '%clozapine%'
  --AND p.LabChemTestName NOT LIKE '%cyclosporine%'
  --AND p.LabChemTestName NOT LIKE '%grans%'
  --AND p.LabChemTestName NOT LIKE '%granulocyte%'
  --AND p.LabChemTestName NOT LIKE '%immunophenotyping%'

select * from #Labs order by LabChemTestName

-- Let's see the Lab Chem Test Names, Lab Procedure Names, and Lab Chem Print Test Names to see which ones
-- can help us most in out selection process.  The one wil the least number of variations will serve us best.
-- These will help us adjust the filters above.  Later queries will help us determine which codes to use.
select LabProcedure, WorkLoadCode5, count(*) as [Count] from #Labs group by LabProcedure, WorkLoadCode5 order by 1,2
select distinct LabChemTestName, LabChemPrintTestName from #Labs order by 1,2
select distinct workloadcode, labchemtestname from #labs order by 2,1

-- How many instances of a workload code are there?  More means a more common lab name throughout the stations.
select WorkloadCode5, count(*) as [Count] from #labs group by workloadcode5 order by count(*) desc

-- How many of each workload's test have been done over the last three years?
drop table #labs2
select WorkLoadCode5, count(distinct b.[LabChemSID]) as [Count] 
into #labs2
from #labs a join cdwwork.chem.patientlabchem b on b.labchemtestsid = a.labchemtestsid
where b.sta3n in (select distinct sta3n from cdwwork.dim.vistasite)
  and b.LabChemCompleteDateTime >= convert(DATE, dateadd(yy, -3, getdate()))
group by a.workloadcode5

select * from #labs2 order by [count] desc
--select * from #labs where WorkLoadCode5 in ('84225', '89446', '88275', '89443', '89447', '89445', '90883', '90885', '89456', '90882', '89039', '89441') order by WorkLoadCode5

-- Which workload codes have the highest counts of LabChemTestSIDs?  This usually trends with the previous query.
select WorkloadCode5, count(distinct LabChemTestSID) AS [Count]
from #labs
where WorkLoadCode5 in (select distinct WorkLoadCode5 from #labs2)
group by WorkLoadCode5
order by count(distinct LabChemTestSID) desc

-- Is there a numeric result value?
select top 100 a.sta3n, a.PatientSID, a.LabChemCompleteDateTime, a.LabChemResultValue, a.LabChemResultNumericValue
from cdwwork.chem.patientlabchem a join #labs b on b.labchemtestsid = a.labchemtestsid

-- Get Lab Procedure Names, you need them for PMMasterCohortLabTestGroups.  By now you should
-- have made the determination of which lab groups you're going to keep and use.
drop table #LabChemTest
select a.LabChemTestSID, a.Sta3n, a.LabChemTestName, a.LabChemPrintTestName, a.NationalVALabCodeSID, b.LabProcedure, b.WorkloadCode
into #LabChemTest
from [CDWWork].[Dim].[LabChemTest] a
join [CDWWork].[Dim].[NationalVALabCode] b ON b.NationalVALabCodeSID = a.NationalVALabCodeSID
where b.workloadcode like '88275%' or
      b.workloadcode like '84225%' or
      b.workloadcode like '89446%' or
      b.workloadcode like '90885%' or
      b.workloadcode like '89443%' or
      b.workloadcode like '89447%' or
      b.workloadcode like '90883%' or
      b.workloadcode like '90882%' or
      b.workloadcode like '89445%'

-- You'll see from this that there is a good deal of variance in the lab chem test name.
select distinct workloadcode, labprocedure from #LabChemTest order by 1,2

-- Clean up and consolidate the lab procedure name.  Only use the first 5 digits of the workload code.
-- These are the records you will need to insert into PanMgmt.PMMasterCohortLabTestGroups.
-- Show a count of records as well in case a code has more than one lab procedure name.  Use the
-- description of the code with the highest count.
select Left(WorkloadCode, 5) AS WorkloadCode,
  LabProcedure = CASE
    When CHARINDEX('~', LabProcedure) = 0 Then LabProcedure
    Else SUBSTRING(LabProcedure, 1, CHARINDEX('~', LabProcedure) - 1)
  End,
  count(*) AS [Count]
from #LabChemTest
group by Left(WorkloadCode, 5),
    CASE
    When CHARINDEX('~', LabProcedure) = 0 Then LabProcedure
    Else SUBSTRING(LabProcedure, 1, CHARINDEX('~', LabProcedure) - 1)
  End
order by 1,2



-- Now look at the LOINC codes

-- How many tests does each loinc code have?  Higher numbers may indicate more test name consistency
-- throughout the facilities.
select loinc, count(distinct LabChemTestSID) AS [Count]
from #Labs
where loinc != '*Missing*'
group by loinc
order by count(distinct LabChemTestSID) desc

select * from #labs where loinc in ('13068-2', '5048-4', '20399-2', '8061-4', '20401-6', '20398-4', '29953-7', '5077-3')

-- How many of each loinc's test have been done over the last three years?
Drop table #labs3
select a.Loinc, count(distinct b.[LabChemSID]) as [Count] 
into #labs3
from #labs a join cdwwork.chem.patientlabchem b on b.labchemtestsid = a.labchemtestsid
where b.sta3n in (select distinct sta3n from cdwwork.dim.vistasite)
  and b.LabChemCompleteDateTime >= convert(DATE, dateadd(yy, -3, getdate()))
group by a.Loinc

-- What are the most used loinc codes?
select * from #labs3 order by count desc

-- For what appear to be the correct codes, cross-check against workload code.
select workloadcode5, count(*) AS [Count]
from #Labs
where loinc in ('13068-2', '5048-4', '20399-2', '20398-4', '29953-7', '20401-6', '5077-3')
group by workloadcode5
order by [Count] desc

-- What's the breakdown of loincs by workload code?
select loinc, workloadcode5, count(*) AS [Count]
from #labs
where loinc in ('13068-2', '5048-4', '20399-2', '20398-4', '29953-7', '20401-6', '5077-3')
group by loinc, workloadcode5
order by count(*) desc


-- So for WBC (white blood cell count) lab, workloads: 85030%, 85569% and 81253%.  LOINCS: 6690-2, 805-2 and 26466-3
-- seem to be the correct ones to use.  These will be put into [PanelMgmt].[PMMasterCohortLabTestGroups]
-- and [PanelMgmt].[PMMasterCohortLabTestGroupsLOINCCodes].


/*
-- Insert the base (reference) data into Panel Management.

-- Labs to track for a cohort (one record per lab per cohort).
select * from [NWIC_PanelMgmt].PanelMgmt.PMMasterLabTestGroupsCohort

insert into [NWIC_PanelMgmt].PanelMgmt.PMMasterLabTestGroupsCohort
values (24,'NVCC','CHLORIDE')

-- Lab test groups
select * from NWIC_PanelMgmt.PanelMgmt.PMMasterCohortLabTestGroups

insert into NWIC_PanelMgmt.PanelMgmt.PMMasterCohortLabTestGroups
values (44, 'CHLORIDE', 1, 'Chloride', '82435.0000', '82435%')

insert into NWIC_PanelMgmt.PanelMgmt.PMMasterCohortLabTestGroups
values (45, 'CHLORIDE', 1, 'Chloride Misc', '81873.0000', '81873%')

insert into NWIC_PanelMgmt.PanelMgmt.PMMasterCohortLabTestGroups
values (46, 'CHLORIDE', 1, 'Chloride Urine', '82196.0000', '82196%')

insert into NWIC_PanelMgmt.PanelMgmt.PMMasterCohortLabTestGroups
values (47, 'CHLORIDE', 1, 'Chloride Urine 24h', '82203.0000', '82203%')

-- Lab test LOINCs - get the long name and system from http://www.loinc.org
select * from NWIC_PanelMgmt.PanelMgmt.PMMasterCohortLabTestGroupsLOINCCodes

Insert into NWIC_PanelMgmt.PanelMgmt.PMMasterCohortLabTestGroupsLOINCCodes
(RowID, TestGroup, ResultForTestNumeric, LongName, LOINC, System, YearSearchCriteria, LastUpdate)
values (33, 'CHLORIDE', 1, 'Chloride [Molecules/volume] in Serum or Plasma', '2075-0', 'Ser/Plas', -1, getdate())

Insert into NWIC_PanelMgmt.PanelMgmt.PMMasterCohortLabTestGroupsLOINCCodes
(RowID, TestGroup, ResultForTestNumeric, LongName, LOINC, System, YearSearchCriteria, LastUpdate)
values (34, 'CHLORIDE', 1, 'Chloride [Molecules/time] in 24 hour Urine', '2079-2', 'CSF', -1, getdate())

*/


select * from cdwwork.dim.nationalvalabcode where NationalVALabCodeSID=800268155